create or replace package tbicds.PCK_AP_USERADMIN
AUTHID CURRENT_USER 
is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  procedure InsertSuatUser(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           pi_vProviderID      in varchar2,
                           pi_nlocked          in number,
                           pi_vName            in varchar2,
                           pi_vRank            in varchar2,
                           pi_nServiceID       in number,
                           pi_vTitle           in varchar2,
                           pi_vCorps           in varchar2,
                           pi_vSquadron        in varchar2,
                           pi_vOfficeSymbol    in varchar2,
                           pi_vPhone           in varchar2,
                           pi_vEmail           in varchar2,
                           pi_vDimsID          in varchar2,
                           pi_vUIDPWD          in varchar2,
                           pi_nMustChgPwd      in number,
                           pi_vSupervisorID    in varchar2,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2);

  procedure UpdateSuatUser(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           pi_vProviderID      in varchar2,
                           pi_vCurrentDimsID   in varchar2,
                           pi_nlocked          in number,
                           pi_vName            in varchar2,
                           pi_vRank            in varchar2,
                           pi_nServiceID       in number,
                           pi_vTitle           in varchar2,
                           pi_vCorps           in varchar2,
                           pi_vSquadron        in varchar2,
                           pi_vOfficeSymbol    in varchar2,
                           pi_vPhone           in varchar2,
                           pi_vEmail           in varchar2,
                           pi_vDimsID          in varchar2,
                           pi_vUIDPWD          in varchar2,
                           pi_nMustChgPwd      in number,
                           pi_vSupervisorID    in varchar2,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2);

  procedure GetUserRightsRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2,
                            rs                  out sys_refcursor);

  procedure GetUserTypesRS(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2,
                           rs                  out sys_refcursor);

  procedure GetSUATUsersRS(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2,
                           rs                  out sys_refcursor);

  procedure GetUserPermissionsRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_nRights          in number,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out sys_refcursor);

  procedure GetInternSupervisorsRS(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2,
                                   rs                  out sys_refcursor);

  procedure InsertRightsTemplate(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_nUserType        in number,
                                 pi_nUserRights      in number,
                                 pi_nRightsMode      in number,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2);

  procedure UpdateRightsTemplate(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_nUserType        in number,
                                 pi_nUserRights      in number,
                                 pi_nRightsMode      in number,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2);

  procedure GetRightsTemplateRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out sys_refcursor);

end;
/

